/*
 * Decompiled with CFR 0.152.
 */
package com.sansec.x509;

import com.sansec.asn1.ASN1Encodable;
import com.sansec.asn1.ASN1EncodableVector;
import com.sansec.asn1.DERBitString;
import com.sansec.asn1.DERGeneralizedTime;
import com.sansec.asn1.DERInteger;
import com.sansec.asn1.DERObjectIdentifier;
import com.sansec.asn1.DERSequence;
import com.sansec.asn1.x509.AlgorithmIdentifier;
import com.sansec.asn1.x509.AttCertIssuer;
import com.sansec.asn1.x509.Attribute;
import com.sansec.asn1.x509.AttributeCertificate;
import com.sansec.asn1.x509.AttributeCertificateInfo;
import com.sansec.asn1.x509.V2AttributeCertificateInfoGenerator;
import com.sansec.asn1.x509.X509ExtensionsGenerator;
import com.sansec.x509.AttributeCertificateHolder;
import com.sansec.x509.AttributeCertificateIssuer;
import com.sansec.x509.ExtCertificateEncodingException;
import com.sansec.x509.X509Attribute;
import com.sansec.x509.X509AttributeCertificate;
import com.sansec.x509.X509Util;
import com.sansec.x509.X509V2AttributeCertificate;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.util.Date;
import java.util.Iterator;

public class X509V2AttributeCertificateGenerator {
    private V2AttributeCertificateInfoGenerator acInfoGen = new V2AttributeCertificateInfoGenerator();
    private DERObjectIdentifier sigOID;
    private AlgorithmIdentifier sigAlgId;
    private String signatureAlgorithm;
    private X509ExtensionsGenerator extGenerator = new X509ExtensionsGenerator();

    public void reset() {
        this.acInfoGen = new V2AttributeCertificateInfoGenerator();
        this.extGenerator.reset();
    }

    public void setHolder(AttributeCertificateHolder holder) {
        this.acInfoGen.setHolder(holder.holder);
    }

    public void setIssuer(AttributeCertificateIssuer issuer) {
        this.acInfoGen.setIssuer(AttCertIssuer.getInstance(issuer.form));
    }

    public void setSerialNumber(BigInteger serialNumber) {
        this.acInfoGen.setSerialNumber(new DERInteger(serialNumber));
    }

    public void setNotBefore(Date date) {
        this.acInfoGen.setStartDate(new DERGeneralizedTime(date));
    }

    public void setNotAfter(Date date) {
        this.acInfoGen.setEndDate(new DERGeneralizedTime(date));
    }

    public void setSignatureAlgorithm(String signatureAlgorithm) {
        this.signatureAlgorithm = signatureAlgorithm;
        try {
            this.sigOID = X509Util.getAlgorithmOID(signatureAlgorithm);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unknown signature type requested");
        }
        this.sigAlgId = X509Util.getSigAlgID(this.sigOID, signatureAlgorithm);
        this.acInfoGen.setSignature(this.sigAlgId);
    }

    public void addAttribute(X509Attribute attribute) {
        this.acInfoGen.addAttribute(Attribute.getInstance(attribute.toASN1Object()));
    }

    public void setIssuerUniqueId(boolean[] iui) {
        throw new RuntimeException("not implemented (yet)");
    }

    public void addExtension(String oid, boolean critical, ASN1Encodable value) throws IOException {
        this.extGenerator.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public void addExtension(String oid, boolean critical, byte[] value) {
        this.extGenerator.addExtension(new DERObjectIdentifier(oid), critical, value);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey key, String provider) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        return this.generateCertificate(key, provider, null);
    }

    public X509AttributeCertificate generateCertificate(PrivateKey key, String provider, SecureRandom random) throws NoSuchProviderException, SecurityException, SignatureException, InvalidKeyException {
        try {
            return this.generate(key, provider, random);
        }
        catch (NoSuchProviderException e) {
            throw e;
        }
        catch (SignatureException e) {
            throw e;
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new SecurityException("exception creating certificate: " + e);
        }
    }

    public X509AttributeCertificate generate(PrivateKey key, String provider) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, SignatureException, InvalidKeyException, NoSuchAlgorithmException {
        return this.generate(key, provider, null);
    }

    public X509AttributeCertificate generate(PrivateKey key, String provider, SecureRandom random) throws CertificateEncodingException, IllegalStateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!this.extGenerator.isEmpty()) {
            this.acInfoGen.setExtensions(this.extGenerator.generate());
        }
        AttributeCertificateInfo acInfo = this.acInfoGen.generateAttributeCertificateInfo();
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(acInfo);
        v.add(this.sigAlgId);
        try {
            v.add(new DERBitString(X509Util.calculateSignature(this.sigOID, this.signatureAlgorithm, provider, key, random, acInfo)));
            return new X509V2AttributeCertificate(new AttributeCertificate(new DERSequence(v)));
        }
        catch (IOException e) {
            throw new ExtCertificateEncodingException("constructed invalid certificate", e);
        }
    }

    public Iterator getSignatureAlgNames() {
        return X509Util.getAlgNames();
    }
}

